/**
 * 
 */
package com.ejie.ab18a.control.mantenimiento;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab18a.model.Ab18aTipoBoletin;
import com.ejie.ab18a.service.Ab18aTipoBoletinService;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * @author XXXX
 * 
 */
@Controller
@RequestMapping(value = "/boletin")
public class Ab18aBoletinMtoController {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aBoletinMtoController.class);

	@Autowired
	private Ab18aTipoBoletinService ab18aTipoBoletinService;

	@RequestMapping(value = "mantenimiento", method = RequestMethod.GET)
	public String viewMantenimiento() {
		logger.info("mantenimiento de Boletines");
		return "ab18aBoletinMantenimiento";
	}

	/**
	 * Buscamos los boletines correspondientes a los valores del filtro
	 **/
	@RequestMapping(value = "mantenimiento/tabla", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridResponseDto<Ab18aTipoBoletin> buscarBoletines(@ModelAttribute() Ab18aTipoBoletin boletinFiltro, @ModelAttribute() JQGridRequestDto request) {

		List<Ab18aTipoBoletin> listaApp = new ArrayList<Ab18aTipoBoletin>();
		Long recordNum = Long.valueOf("12125");
		try {
			listaApp = this.ab18aTipoBoletinService.findAllLike(boletinFiltro, request, false);
			recordNum = this.ab18aTipoBoletinService.findAllLikeCount(boletinFiltro, false);
		} catch (Exception e) {
			Ab18aBoletinMtoController.logger.error("Ab18aBoletinMtoController - buscarBoletines() - Error al obtener los boletines - " + e);
		}

		JQGridResponseDto<Ab18aTipoBoletin> response = new JQGridResponseDto<Ab18aTipoBoletin>(request, recordNum, listaApp);
		return response;
	}

	/**
	 * Method 'guardarMantenimiento'.
	 * 
	 * @param mantenimiento
	 *            Y96bMantenimiento
	 * @return Y96bMantenimiento
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Ab18aTipoBoletin guardarMantenimiento(@RequestBody Ab18aTipoBoletin mantenimiento) {
		Ab18aTipoBoletin mantenimientoAux = null;

		if (mantenimiento.getT06IdBoletin() != null && mantenimiento.getT06IdBoletin() > 0) {
			/**
			 * idRegistro > 0 implica que es una modificación.
			 */
			mantenimientoAux = this.ab18aTipoBoletinService.update(mantenimiento);
			Ab18aBoletinMtoController.logger.info("[POST] : Ab18aTipoBoletin mantenimiento actualizado correctamente");
		} else {
			/**
			 * Si tenemos idRegistro vacío es un alta de registro
			 */
			try {
				mantenimientoAux = this.ab18aTipoBoletinService.add(mantenimiento);
				Ab18aBoletinMtoController.logger.info("[POST] : Ab18aTipoBoletin mantenimiento insertado correctamente");
			} catch (Exception e) {
				Ab18aBoletinMtoController.logger.error("[POST] : Ab18aTipoBoletin error al añadir un registro al mantenimiento: " + e);
			}
		}

		return mantenimientoAux;
	}

}
